/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.entity_sync;

import java.util.List;
import java.util.Set;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.chunk_loading.NewChunkTrackingGraph;
import qouteall.imm_ptl.core.ducks.IEEntityTracker;
import qouteall.imm_ptl.core.ducks.IEEntityTrackerEntry;
import qouteall.imm_ptl.core.ducks.IEThreadedAnvilChunkStorage;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.network.PacketRedirection;

@Mixin(value={ChunkMap.TrackedEntity.class})
public abstract class MixinTrackedEntity
implements IEEntityTracker {
    @Shadow
    @Final
    private ServerEntity f_140471_;
    @Shadow
    @Final
    private Entity f_140472_;
    @Shadow
    @Final
    private int f_140473_;
    @Shadow
    @Final
    private Set<ServerPlayerConnection> f_140475_;
    @Shadow
    private SectionPos f_140474_;

    @Shadow
    public abstract void m_140482_();

    @Shadow
    protected abstract int m_140496_();

    @Redirect(method={"Lnet/minecraft/server/level/ChunkMap$TrackedEntity;broadcast(Lnet/minecraft/network/protocol/Packet;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerConnection;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendToOtherNearbyPlayers(ServerPlayerConnection entityTrackingListener, Packet<?> packet) {
        PacketRedirection.withForceRedirect((ServerLevel)this.f_140472_.m_9236_(), () -> entityTrackingListener.m_9829_(packet));
    }

    @Redirect(method={"Lnet/minecraft/server/level/ChunkMap$TrackedEntity;broadcastAndSend(Lnet/minecraft/network/protocol/Packet;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;send(Lnet/minecraft/network/protocol/Packet;)V"))
    private void onSendToNearbyPlayers(ServerGamePacketListenerImpl serverPlayNetworkHandler, Packet packet_1) {
        PacketRedirection.sendRedirectedPacket(serverPlayNetworkHandler, (Packet<ClientGamePacketListener>)packet_1, (ResourceKey<Level>)this.f_140472_.m_9236_().m_46472_());
    }

    @Inject(method={"updatePlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdatePlayer(ServerPlayer player, CallbackInfo ci) {
        this.updateEntityTrackingStatus(player);
        ci.cancel();
    }

    @Overwrite
    public void m_140487_(List<ServerPlayer> list) {
        for (ServerPlayer player : McHelper.getRawPlayerList()) {
            this.updateEntityTrackingStatus(player);
        }
    }

    @Override
    public Entity getEntity_() {
        return this.f_140472_;
    }

    @Override
    @IPVanillaCopy
    public void updateEntityTrackingStatus(ServerPlayer player) {
        boolean isWatchedNow;
        IEThreadedAnvilChunkStorage storage = (IEThreadedAnvilChunkStorage)((ServerLevel)this.f_140472_.m_9236_()).m_7726_().f_8325_;
        if (player == this.f_140472_) {
            return;
        }
        ProfilerFiller profiler = player.m_9236_().m_46473_();
        profiler.m_6180_("portal_entity_track");
        int maxWatchDistance = Math.min(this.m_140496_(), (storage.ip_getWatchDistance() - 1) * 16);
        ChunkPos chunkPos = this.f_140472_.m_146902_();
        boolean bl = isWatchedNow = NewChunkTrackingGraph.isPlayerWatchingChunkWithinRadius(player, (ResourceKey<Level>)this.f_140472_.m_9236_().m_46472_(), chunkPos.f_45578_, chunkPos.f_45579_, maxWatchDistance) && this.f_140472_.m_6459_(player);
        if (isWatchedNow) {
            if (this.f_140475_.add((ServerPlayerConnection)player.f_8906_)) {
                this.f_140471_.m_8541_(player);
            }
        } else if (this.f_140475_.remove(player.f_8906_)) {
            this.f_140471_.m_8534_(player);
        }
        profiler.m_7238_();
    }

    @Override
    public void ip_onDimensionRemove() {
        for (ServerPlayerConnection connection : this.f_140475_) {
            this.f_140471_.m_8534_(connection.m_142253_());
        }
        this.f_140475_.clear();
    }

    @Override
    public void resendSpawnPacketToTrackers() {
        ((IEEntityTrackerEntry)this.f_140471_).ip_updateTrackedEntityPosition();
        Packet spawnPacket = this.f_140472_.m_5654_();
        Packet<ClientGamePacketListener> redirected = PacketRedirection.createRedirectedMessage((ResourceKey<Level>)this.f_140472_.m_9236_().m_46472_(), (Packet<ClientGamePacketListener>)spawnPacket);
        this.f_140475_.forEach(handler -> handler.m_9829_(redirected));
    }

    @Override
    public void stopTrackingToAllPlayers_() {
        this.m_140482_();
    }

    @Override
    public void tickEntry() {
        this.f_140471_.m_8533_();
    }

    @Override
    public SectionPos getLastCameraPosition() {
        return this.f_140474_;
    }

    @Override
    public void setLastCameraPosition(SectionPos arg) {
        this.f_140474_ = arg;
    }

    @Override
    public void ip_onPlayerDisconnect(ServerPlayer player) {
        if (this.f_140475_.remove(player.f_8906_)) {
            this.f_140472_.m_6452_(player);
        }
    }
}

